<?php

namespace App\Models\Judgment;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Judgment extends Model 
{

    protected $table = 'Judgment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('notes', 'case_status_id');

    public function status()
    {
        return $this->hasMany('Status');
    }

    public function case()
    {
        return $this->belongsTo('Xcase');
    }

}